/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.world.level.levelgen.structure.crater;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import corgitaco.enhancedcelestials.util.FastNoise;
import corgitaco.enhancedcelestials.world.level.levelgen.structure.ECStructurePieceTypes;
import corgitaco.enhancedcelestials.world.level.levelgen.structure.crater.CraterStructure;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;

public class CraterPiece
extends StructurePiece {
    protected static FastNoise fastNoise = (FastNoise)Util.m_137469_((Object)new FastNoise(20202), noise -> {
        noise.SetNoiseType(FastNoise.NoiseType.Simplex);
        noise.SetFrequency(0.004f);
    });
    private final CraterStructure.PieceStructureInfo structureInfo;

    protected CraterPiece(CraterStructure.PieceStructureInfo structureInfo, int genDepth, BoundingBox boundingBox) {
        super(ECStructurePieceTypes.CRATER_PIECE.get(), genDepth, boundingBox);
        this.structureInfo = structureInfo;
    }

    public CraterPiece(StructurePieceSerializationContext context, CompoundTag tag) {
        super(ECStructurePieceTypes.CRATER_PIECE.get(), tag);
        this.structureInfo = (CraterStructure.PieceStructureInfo)((Pair)CraterStructure.PieceStructureInfo.CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("crater_info")).result().orElseThrow()).getFirst();
    }

    protected void m_183620_(StructurePieceSerializationContext context, CompoundTag compoundTag) {
        compoundTag.m_128365_("crater_info", (Tag)CraterStructure.PieceStructureInfo.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.structureInfo).result().orElseThrow());
    }

    public void m_213694_(WorldGenLevel worldGenLevel, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource randomSource, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
        double radius = this.structureInfo.baseRadiusX();
        double radiusZ = this.structureInfo.baseRadiusZ();
        double yRadius = 40.0;
        BlockPos origin = this.structureInfo.origin();
        int baseHeight = origin.m_123342_();
        BlockPos subtract = origin.m_7918_((int)(-radius), 0, (int)(-radiusZ));
        int startX = subtract.m_123341_();
        int startZ = subtract.m_123343_();
        BlockPos add = origin.m_7918_((int)radius, 0, (int)radiusZ);
        int endX = add.m_123341_();
        int endZ = add.m_123343_();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int minX = Math.max(startX - 10, chunkPos.m_45604_());
        int maxX = Math.min(endX + 10, chunkPos.m_45608_());
        int minZ = Math.max(startZ - 10, chunkPos.m_45605_());
        int maxZ = Math.min(endZ + 10, chunkPos.m_45609_());
        double xRadiusSquared = radius * radius;
        double yRadiusSquared = yRadius * yRadius;
        double zRadiusSquared = radiusZ * radiusZ;
        for (int worldX = minX; worldX <= maxX; ++worldX) {
            int localX = worldX - origin.m_123341_();
            mutable.m_122178_(worldX, 0, 0);
            for (int worldZ = minZ; worldZ <= maxZ; ++worldZ) {
                int localZ = worldZ - origin.m_123343_();
                mutable.m_122178_(worldX, 0, worldZ);
                for (double y = -yRadius; y <= yRadius; y += 1.0) {
                    mutable.m_122169_((double)worldX, (double)baseHeight + y, (double)worldZ);
                    double equationResult = (double)(localX * localX) / xRadiusSquared + y * y / yRadiusSquared + (double)(localZ * localZ) / zRadiusSquared;
                    double threshold = 1.0 + 0.7 * (double)fastNoise.GetNoise(mutable.m_123341_(), mutable.m_123343_());
                    if (equationResult >= 1.0) continue;
                    worldGenLevel.m_7731_((BlockPos)mutable, Blocks.f_50016_.m_49966_(), 3);
                }
            }
        }
    }
}

